<section class="about-area pt-120 pb-120 shortcode-about-us-information shortcode-about-us-information-style-1" style="<?php echo \Illuminate\Support\Arr::toCssStyles($variablesStyle) ?>">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="about-img-wrap">
                    <?php if($image = $shortcode->image): ?>
                        <div class="mask-img-wrap">
                            <?php echo e(RvMedia::image($image, 'about-us-information-image')); ?>

                        </div>
                    <?php endif; ?>

                    <div class="experience-year">
                        <div class="icon">
                            <i class="flaticon-trophy"></i>
                        </div>

                        <?php if(($dataCount = $shortcode->data_count) && ($dataCountDes = $shortcode->data_count_description)): ?>
                            <div class="content">
                                <h6 class="circle rotateme"><?php echo BaseHelper::clean($dataCountDes); ?> <?php echo e($dataCount); ?> -</h6>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="about-content">
                    <div class="section-title mb-35 tg-heading-subheading animation-style3">
                        <?php if($subtitle = $shortcode->subtitle): ?>
                            <span class="sub-title"><?php echo BaseHelper::clean($subtitle); ?></span>
                        <?php endif; ?>

                        <?php if($title = $shortcode->title): ?>
                            <h2 class="title tg-element-title"><?php echo BaseHelper::clean($title); ?></h2>
                        <?php endif; ?>
                    </div>

                    <?php if(count($tabs) > 0): ?>
                        <div class="about-list">
                            <?php echo Theme::partial('shortcodes.about-us-information.partials.featured-list', compact('tabs')); ?>

                        </div>
                    <?php endif; ?>

                    <?php if($description = $shortcode->description): ?>
                        <p class="truncate-3-custom"><?php echo BaseHelper::clean($description); ?></p>
                    <?php endif; ?>

                    <div class="about-bottom">
                        <?php echo Theme::partial('shortcodes.about-us-information.partials.author', compact('shortcode')); ?>


                        <?php if(($buttonLabel = $shortcode->button_label) && ($buttonUrl = $shortcode->button_url)): ?>
                            <a href="<?php echo e($buttonUrl); ?>" class="btn btn-two"><?php echo BaseHelper::clean($buttonLabel); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH C:\xampp\htdocs\Mane_website\platform\themes/apexa/partials/shortcodes/about-us-information/styles/style-1.blade.php ENDPATH**/ ?>