<?php
    $logo = Arr::get($config, 'logo', theme_option('logo'));
?>

<div class="col widget-information widget-information-style-2">
    <div class="footer-widget">
        <?php if($logo): ?>
            <div class="fw-logo mb-25">
                <a href="<?php echo e(BaseHelper::getHomepageUrl()); ?>">
                    <?php echo e(RvMedia::image($logo, theme_option('site_title'))); ?>

                </a>
            </div>
        <?php endif; ?>

        <div class="footer-content">
            <?php if($description = Arr::get($config, 'description')): ?>
                <p><?php echo BaseHelper::clean($description); ?></p>
            <?php endif; ?>

            <?php if(Arr::get($config, 'display_social_links') && ($items = Theme::getSocialLinks())): ?>
                <div class="footer-social">
                    <ul class="list-wrap">
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a title="<?php echo e($item->getName()); ?>" href="<?php echo e($item->getUrl()); ?>">
                                    <?php echo $item->getIconHtml(); ?>

                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\Mane_website\platform\themes/apexa/widgets/site-information/templates/styles/style-2.blade.php ENDPATH**/ ?>