<?php
    $bgImage = Theme::get('breadcrumb_background_image') ?: theme_option('breadcrumb_background_image');
    $bgColor = Theme::get('breadcrumb_background_color') ?: theme_option('breadcrumb_background_color');
    $textColor = Theme::get('breadcrumb_text_color') ?: theme_option('breadcrumb_text_color');
    $height = Theme::get('breadcrumb_height') ?: theme_option('breadcrumb_height');
    $height = (int) $height ? $height . 'px' : 'auto';
    $hasTextColor = $textColor && $textColor !== 'transparent';
?>

<?php if($pageTitle = Theme::get('pageTitle')): ?>
    <section class="breadcrumb__area breadcrumb__bg" <?php if($bgImage): ?> data-background="<?php echo e(RvMedia::getImageUrl($bgImage)); ?>" <?php endif; ?>
        style="<?php echo \Illuminate\Support\Arr::toCssStyles([
            '--breadcrumb-bg-color: ' . $bgColor => $bgColor,
            '--breadcrumb-txt-color: ' . $textColor => $hasTextColor,
            '--breadcrumb-height: ' . $height => $height,
        ]) ?>"
    >
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="breadcrumb__content">
                        <h2 class="title"><?php echo BaseHelper::clean($pageTitle); ?></h2>
                        <?php if(Theme::breadcrumb()->enabled()): ?>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <?php $__currentLoopData = Theme::breadcrumb()->getCrumbs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(! $loop->last): ?>
                                            <li class="breadcrumb-item">
                                                <a href="<?php echo e($crumb['url']); ?>" title="<?php echo e($crumb['label']); ?>">
                                                    <?php echo e($crumb['label']); ?>

                                                </a>
                                            </li>
                                        <?php else: ?>
                                            <li class="breadcrumb-item active"><?php echo e($crumb['label']); ?></li>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ol>
                            </nav>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\Mane_website\platform\themes/apexa/partials/breadcrumbs.blade.php ENDPATH**/ ?>