<?php
    $bgColor = theme_option('header_top_background_color', '#0e104b');
    $textColor = theme_option('header_top_text_color', '#ffffff');
    $customContainer ??= true;

    $ecommerceActive = is_plugin_active('ecommerce');
?>

<div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['tg-header__top', 'ecommerce' => $ecommerceActive, $wrapperClass ?? null]); ?>"
    style="<?php echo \Illuminate\Support\Arr::toCssStyles([
        "--header-top-background-color: $bgColor" => $bgColor,
        "--header-top-text-color: $textColor" => $textColor,
    ]) ?>"
>
    <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['container', 'custom-container' => $customContainer]); ?>">
        <div class="row">
            <div class="<?php echo e($ecommerceActive ? 'col-lg-8' : 'col-lg-6'); ?>">
                <?php echo dynamic_sidebar('header_top_start_sidebar'); ?>

            </div>
            <div class="<?php echo e($ecommerceActive ? 'col-lg-4' : 'col-lg-6'); ?>">
                <?php if($ecommerceActive): ?>
                    <?php echo Theme::partial('header.action-buttons.ecommerce-action-buttons'); ?>

                <?php else: ?>
                    <?php echo dynamic_sidebar('header_top_end_sidebar'); ?>

                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\Mane_website\platform\themes/apexa/partials/header/header-top.blade.php ENDPATH**/ ?>