<?php
    $tabs = Shortcode::fields()->getTabsData(['title', 'description', 'icon', 'icon_image'], $shortcode);
?>

<section class="contact__area shortcode-contact-form">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-5">
                <div class="contact__content">
                    <div class="section-title mb-35">
                        <?php if($title = $shortcode->title): ?>
                            <h2 class="title"><?php echo BaseHelper::clean($title); ?></h2>
                        <?php endif; ?>

                        <?php if($description = $shortcode->description): ?>
                            <p class="truncate-3-custom"><?php echo BaseHelper::clean($description); ?></p>
                        <?php endif; ?>
                    </div>

                    <?php if(count($tabs)): ?>
                        <div class="contact__info">
                            <ul class="list-wrap">
                                <?php $__currentLoopData = $tabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(! $title = Arr::get($item, 'title')) continue; ?>
                                    <li>
                                        <div class="icon">
                                            <?php if($iconImage = Arr::get($item, 'icon_image')): ?>
                                                <?php echo e(RvMedia::image($iconImage, 'icon')); ?>

                                            <?php elseif($icon = Arr::get($item, 'icon')): ?>
                                                <?php if (isset($component)) { $__componentOriginal73995948b3bd877b76251b40caf28170 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73995948b3bd877b76251b40caf28170 = $attributes; } ?>
<?php $component = Botble\Icon\View\Components\Icon::resolve(['name' => $icon] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('core::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Botble\Icon\View\Components\Icon::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $attributes = $__attributesOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__attributesOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $component = $__componentOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__componentOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                        <div class="content">
                                            <h4 class="title"><?php echo BaseHelper::clean($title); ?></h4>

                                            <?php if($description = Arr::get($item, 'description')): ?>
                                                <p><?php echo BaseHelper::clean($description); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-7">
                <div class="contact__form-wrap">
                    <?php if($formTitle = $shortcode->form_title): ?>
                        <h2 class="title"><?php echo BaseHelper::clean($formTitle); ?></h2>
                    <?php endif; ?>

                    <?php if($formDescription = $shortcode->form_description): ?>
                        <p class="truncate-2-custom"><?php echo BaseHelper::clean($formDescription); ?></p>
                    <?php endif; ?>

                    <?php echo $form
                        ->setFormInputClass('')
                        ->setFormInputWrapperClass('form-grp')
                        ->setFormLabelClass('form-label d-none')
                        ->modify(
                            'submit', 'submit', ['attr' => ['class' => 'btn'], 'label' => $shortcode->form_button_label ?: __('Submit')], true)
                        ->renderForm(); ?>

                    <p class="ajax-response mb-0"></p>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH C:\xampp\htdocs\Mane_website\platform\themes/apexa/partials/shortcodes/contact-form/index.blade.php ENDPATH**/ ?>